﻿/* Skript zur Demonstration von MUTLITABLE-INSERT-Anweisungen
 * Als Benutzer SCOTT ausführen
 */
 

-- Vorbereitung
create table emp_10 as
select *
  from emp
 where 1=0;

create table emp_20 as
select *
  from emp
 where 1=0;

create table emp_30 as
select *
  from emp
 where 1=0;
 
-- Kopieren aller Daten aus EMP in mehrere Tabellen
insert all
  into emp_10
  into emp_20
  into emp_30
select *
  from emp;
  
select count(*)
  from emp_30;
  
rollback;

-- Kopieren aller Daten einer Abteilung in die jeweilige Tabelle:
insert first
  when deptno = 10 then
  into emp_10
  when deptno = 20 then
  into emp_20
  when deptno = 30 then
  into emp_30
select *
  from emp;
  
select count(*)
  from emp_30;
  
rollback;

-- Kopieren aller Daten einer Abteilung in die jeweilige Tabelle
-- Erweiterung um eine else-Klausel und eine explizite Spaltenliste
insert first
  when deptno = 10 then
  into emp_10
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  when deptno = 20 then
  into emp_20
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  else
  into emp_30
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
select *
  from emp;
  
select count(*)
  from emp_30;
  
rollback;

create table sales_emp as
select *
  from emp
 where 1 = 0;
 
create table other_emp as
select empno, ename, job, mgr, hiredate, sal, deptno
  from emp
 where 1 = 0;

insert all
  when deptno = 10 then
  into emp_10
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  when deptno = 20 then
  into emp_20
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  when deptno >= 30 then
  into emp_30
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  when job = 'SALESMAN' then
  into sales_emp
    (empno, ename, job, mgr, hiredate, sal, comm, deptno)
  when job != 'SALESMAN' then
  into other_emp
    (empno, ename, job, mgr, hiredate, sal, deptno)
  values
    (empno, ename, job, mgr, hiredate, sal, deptno)
select *
  from emp;
  
select count(*)
  from emp_30;
  
select count(*)
  from sales_emp;
  
select count(*)
  from other_emp;
  
rollback;

/* Änderung des Datenmodells */
drop sequence emp_seq;
create sequence emp_seq start with 1000 increment by 10;

-- Erstellung der neuen EMP-Tabelle
create table employees as 
select empno emp_id, ename emp_name, hiredate
  from emp
 where 1 = 0;
 
-- ERstellung einer separaten JOBS-Tabelle
create table jobs (
  job_id varchar2(30),
  job_name varchar2(50),
  min_sal number,
  max_sal number,
  constraint pk_jobs primary key (job_id));
  
-- Laden des bislang verwendeten Jobs aus EMP
insert into jobs
select job, job, min(sal), max(sal)
  from emp
 group by job;
 
commit;

-- Zuordnungstabelle EMP => JOB
create table employee_job as
select empno emp_id, job job_id, sal, comm, 
       hiredate valid_from, hiredate valid_to
  from emp
 where 1 = 0;
 
-- Zuordnungstabelle EMP => DEPARTMENT
create table employee_department as
select empno emp_id, deptno dept_id, 
       hiredate valid_from, hiredate valid_to
  from emp
 where 1 = 0;
 
-- Zuordnungstabelle EMP = MANAGER
create table employee_mgr as
select empno emp_id, mgr mgr_id, 
       hiredate valid_from, hiredate valid_to
  from emp
 where 1 = 0;
 
-- MULTI-TABLE-INSERT-Anweisung zum Füllen der neuen Tabellen
insert all
       into employees
         (emp_id, emp_name, hiredate)
       values
         (emp_seq.nextval, ename, hiredate)
       into employee_job
         (emp_id, job_id, sal, comm, valid_from, valid_to)
       values
         (emp_seq.currval, job, sal, comm, hiredate, max_date)
       into employee_department
         (emp_id, dept_id, valid_from, valid_to)
       values
         (emp_seq.currval, deptno, hiredate, max_date)
select empno, ename, job, mgr, 
       hiredate, sal, comm, deptno,
       to_date('31.12.2099', 'dd.mm.yyyy') max_date
  from emp;
  
-- Prüfungsabfragen
select *
  from employees;
  
select *
  from employee_department;
  
-- Händische Befüllung der MANAGER-Tabelle
insert into employee_mgr
select e.emp_id, m.emp_id, hiredate,  
       to_date('31.12.2099', 'dd.mm.yyyy')
  from emp 
  join (select emp_id, empno
          from employees e
          join emp a on e.emp_name = a.ename) e on emp.empno = e.empno
  join (select emp_id, empno
          from employees e
          join emp a on e.emp_name = a.ename) m on emp.mgr = m.empno;
          
commit;
